import os
from bs4 import BeautifulSoup
from pathlib import Path

# Config
html_file = Path("/home/josefkulovany/recompiled-pages/index.html")
image_dir = html_file.parent
output_file = html_file.with_name("index_fixed.html")

# Step 1: Load local image names (no path, lowercase match)
local_images = {}
for f in image_dir.iterdir():
    if f.suffix.lower() in ['.jpg', '.jpeg', '.png', '.gif']:
        key = f.name.replace("(1)", "").lower()
        # Prefer full version if it exists
        if key not in local_images or "(1)" in local_images[key]:
            local_images[key] = f.name

# Step 2: Parse HTML and fix image paths
soup = BeautifulSoup(html_file.read_text(encoding="utf-8"), "html.parser")

for img in soup.find_all("img"):
    original_src = img.get("src", "")
    src_basename = os.path.basename(original_src).replace("(1)", "").lower()

    if src_basename in local_images:
        new_src = f"./{local_images[src_basename]}"
        print(f"Fixing image: {original_src} -> {new_src}")
        img['src'] = new_src

# Step 3: Write fixed HTML
output_file.write_text(str(soup), encoding="utf-8")
print(f"\n✅ Fixed HTML saved to: {output_file}")
