from bs4 import BeautifulSoup
from pathlib import Path

# Input/Output HTML
html_path = Path("/home/josefkulovany/recompiled-pages/index.html")
output_path = html_path.with_name("index_manual_mapped.html")

# Your real files
real_images = [
    "272097746_2889050794718330_2429556499248538454_n-Yg21D3gZlKtaKOEq.jpg",
    "272170262_2889010071389069_839111276987981319_n-YbNDK81XJoflBe4N.jpg",
    "293256215_3011295135827228_1062208197907635003_n-AoPEOLNpbxSvk2Dr.jpg",
    "311983307_3096503063973101_4624707471446359481_n-mk3Leaz0bls5W4lq.jpg",
    "312918800_3096502983973109_8016347582259544278_n-Yg21DZPzj9FEQra2.jpg",
    "313425110_3097484513874956_5709197671429153513_n-YbNDKoq75WTWyeRZ.jpg",
    "img_2282-Yg21DoElqKu6lW0g.JPG",
    "unadjustednonraw_thumb_e21-YKboBnV1RpsjBGW2.jpg",
    "untitled-meP38MLj8QhL60qL.png"
]

# Load HTML
soup = BeautifulSoup(html_path.read_text(encoding="utf-8"), "html.parser")

# Replace base64 images
for i, img in enumerate(soup.find_all("img")):
    src = img.get("src", "")
    if src.startswith("data:image"):
        print(f"\n🔍 Found base64 image #{i+1}")
        print("Nearby context:")
        print("-" * 40)
        parent = img.find_parent()
        if parent:
            snippet = parent.get_text().strip()
            print(snippet[:300])
        print("-" * 40)

        # Show options
        print("Choose replacement image (or 's' to skip, 'q' to quit):")
        for idx, name in enumerate(real_images):
            print(f"{idx + 1}. {name}")
        
        while True:
            choice = input("Your choice [number | s | q]: ").strip().lower()
            if choice == 's':
                print("⏭️  Skipped.")
                break
            elif choice == 'q':
                print("👋 Exiting early. Saving progress...")
                output_path.write_text(str(soup), encoding="utf-8")
                exit(0)
            elif choice.isdigit():
                num = int(choice)
                if 1 <= num <= len(real_images):
                    replacement = real_images[num - 1]
                    img['src'] = f"./{replacement}"
                    print(f"✅ Replaced with: {replacement}")
                    break
            print("❌ Invalid input. Try again.")

# Save output
output_path.write_text(str(soup), encoding="utf-8")
print(f"\n🎉 Finished. Updated file saved to: {output_path}")
