# Dashboard Quick Reference

## 🚀 Start Dashboard

```powershell
# Start API server + open browser
.\start_dashboard_simple.ps1

# Custom port
.\start_dashboard_simple.ps1 -Port 3000

# Don't open browser
.\start_dashboard_simple.ps1 -NoBrowser
```

## 🌐 URLs

- **Dashboard**: http://localhost:8080/dashboard.html
- **API Status**: http://localhost:8080/api/status
- **All Nodes**: http://localhost:8080/api/nodes
- **Contracts**: http://localhost:8080/api/contracts

## 📊 Live Features

✅ **Real-time monitoring** (3s refresh)
✅ **Compression graphs** (Chart.js)
✅ **Contract deployment** (Python code)
✅ **Historical tracking** (20 data points)
✅ **DNA consensus** (verified across nodes)

## 🔧 Quick Commands

```powershell
# Deploy nodes first (if not done)
.\deploy.ps1 -Mode local -NumNodes 3

# Start dashboard
.\start_dashboard_simple.ps1

# Test API
Invoke-RestMethod http://localhost:8080/api/status

# Deploy contract via API
$contract = @{
    name = "Test"
    code = "result['message'] = 'Hello'"
} | ConvertTo-Json

Invoke-RestMethod -Uri http://localhost:8080/api/deploy `
    -Method POST -ContentType "application/json" -Body $contract
```

## 📝 Example Contract

```python
# Framework-native contract example
# Access: context['state'], context['contract']
# Output: result dictionary

evolution = context['state'].get('evolution_count', 0)

if evolution > 100:
    result['action'] = 'trigger'
    result['message'] = f'Evolution: {evolution}'
    result['success'] = True
else:
    result['action'] = 'wait'
    result['success'] = False
```

## 🎯 Dashboard Controls

- **📝 Load Example** - Load sample contract
- **🗑️ Clear** - Clear input
- **✓ Validate** - Check syntax
- **⚡ Deploy** - Deploy to framework

## 📈 Data Displayed

| Card | Shows |
|------|-------|
| Node Cards | Compression, DNA, Glyph, Time, Error |
| Cluster Stats | Active nodes, Avg compression, Consensus |
| Live Graph | Compression history (line chart) |
| Bar Chart | Current ratios (all nodes) |
| Contracts | Deployed contracts + execution count |

## 🔍 Troubleshooting

**No data?**
```powershell
# Deploy nodes
.\deploy.ps1 -Mode local -NumNodes 3
```

**API not responding?**
```powershell
# Check if running
Get-NetTCPConnection -LocalPort 8080

# Restart
.\start_dashboard_simple.ps1
```

**Graphs not updating?**
- Check browser console (F12)
- Verify API: http://localhost:8080/api/nodes
- Clear cache (Ctrl+Shift+R)

## 📁 Key Files

- `dashboard.html` - Web UI
- `dashboard_api.py` - API server
- `start_dashboard_simple.ps1` - Launcher
- `deployment/logs/*.log` - Node logs
- `deployment/contracts/*.json` - Deployed contracts

## 🎓 Performance

- **Refresh**: 3 seconds
- **API latency**: < 50ms
- **Memory**: ~10 MB browser, ~20 MB API
- **Nodes**: 42 KB each, ~1 MB RAM

---

**100% Live Data · Zero Docker Bloat · Framework-Native Execution**
