#!/usr/bin/env powershell
<#
.SYNOPSIS
    Continuous node deployment for live dashboard iteration
.DESCRIPTION
    Redeploys nodes every 10 seconds to show live data changes
#>

param(
    [int]$IntervalSeconds = 10,
    [switch]$Forever
)

Write-Host "`n=== CONTINUOUS DEPLOYMENT ===" -ForegroundColor Cyan
Write-Host "Redeploying nodes every $IntervalSeconds seconds" -ForegroundColor Yellow
Write-Host "Press Ctrl+C to stop`n" -ForegroundColor Gray

$iteration = 1

while ($Forever -or $iteration -le 100) {
    Write-Host "[Iteration $iteration] $(Get-Date -Format 'HH:mm:ss')" -ForegroundColor Green

    # Deploy 3 nodes
    1..3 | ForEach-Object {
        wsl bash -c "cd '/mnt/c/Users/Owner/Documents/Josef'\''s Code 2025/K equals epsilon/analog-mainnet/framework_native' && ./analog_codec_native" > "deployment\logs\node$_.log" 2>&1
        Write-Host "  Node $_ deployed: $([math]::Round((Get-Item "deployment\logs\node$_.log").Length/1KB,1))KB" -ForegroundColor White
    }

    Write-Host "  Waiting $IntervalSeconds seconds...`n" -ForegroundColor Gray
    Start-Sleep -Seconds $IntervalSeconds

    $iteration++
}

Write-Host "`n=== DEPLOYMENT COMPLETE ===" -ForegroundColor Cyan
