// Bridge globals compatibility header
#ifndef BRIDGE_GLOBALS_H
#define BRIDGE_GLOBALS_H

#include <pthread.h>

/* Compatibility globals used by the HTTP API module.
 * These mirror the bridge internal state so modules compiled
 * separately can link to a stable set of symbols.
 */
extern pthread_mutex_t g_bridge_lock;
extern double g_analog_state[7];
extern int g_evolution_count;
extern int g_consensus_count;
extern int g_node_id;
// Additional exposed metrics
extern double g_phase_variance;

#endif // BRIDGE_GLOBALS_H
